/*******************************************************************
*
*  DESCRIPTION: Atomic Model Line
*
*  AUTHOR: Scott Stewart
*
*  EMAIL: wtime@live.ca
*
*  DATE: 29/2/2016
*
*******************************************************************/
/** include files **/
#include "line.h"      		// class Line
#include "message.h"        // class ExternalMessage, InternalMessage
#include "mainsimu.h"       // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name: Reception
* Description:
********************************************************************/
Line::Line( const string &name )
: Atomic( name )
, new_person( addInputPort( "new_person" ) )
, ready_for_next( addInputPort( "ready_for_next" ) )
, line_out( addOutputPort( "line_out" ) )
{
	may_pass = true;
}

/*******************************************************************
* Function Name: initFunction
* Description: Resets the list
* Precondition: The time of the next internal event is infinite
********************************************************************/
Model &Line::initFunction()
{
	elements.erase( elements.begin(), elements.end() ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Line::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == new_person ) //Line is of infinite size
	{
		if(may_pass)
		{
			holdIn(active, 0);
		}
		elements.push_back( abs((int)msg.value()) );
	}
	if (msg.port() == ready_for_next) //Line will output one person.
	{
		may_pass = true;
        holdIn( active, 0 ) ;
	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Line::internalFunction( const InternalMessage & )
{
	if(!elements.size() <= 0) //Only need to set may_pass to false if an element was actually passed via the outputFunction
	{
	    elements.pop_front();
	    may_pass = false;
	}
    passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Line::outputFunction( const InternalMessage &msg )
{
	if (elements.size())
	{
		sendOutput( msg.time(), line_out, elements.front() ) ;
	}

	return *this ;
}
