/**
* Ifeoluwa Oyelowo
* SYSC 5104 - Carleton University
* Nov 1, 2016
*
* line: 
	This model accepts people and puts them in a queue. 
	It only outputs a person when the decider model sends a ready signal.
* atomic model line
*/

#ifndef BOOST_SIMULATION_PDEVS_LINE_HPP 
#define BOOST_SIMULATION_PDEVS_LINE_HPP 

#include <math.h> 
#include <assert.h>
#include <memory>
#include <iomanip>
#include <iostream>
#include <fstream>
#include <string>
#include <chrono>
#include <algorithm>
#include <limits>
#include <random>
#include <boost/simulation/pdevs/atomic.hpp>

//#include any other library you need

#include "../data_structures/message.hpp" 

using namespace boost::simulation::pdevs;
using namespace boost::simulation;
using namespace std;


/**
 * @class line
*/

template<class TIME, class MSG>
class line : public pdevs::atomic<TIME, MSG>{ 
private:

  //PARAMETRES
  
   //input port
   string new_person = string("new_person");
   string ready_for_next = string("ready_for_next");

   //output port
   string line_out = string ("line_out");

  
  //STATE VARIABLES
  
  bool may_pass;
  vector<int> elements; //number of people currently in the line
  
public:

  /**
   * @constructor 
   */

  explicit line() noexcept {   
    
    //INITIALIZE THE MODEL PARAMETERS AND VARIABLES. 
    may_pass = true;
    elements.clear();//remove all the elements in the vector
  }

  /**
   * @Internal
   */

  void internal() noexcept {  
    
    if(elements.size() > 0 && may_pass) //If an element is passed, set may_pass to false
    {
        elements.erase(elements.begin());//pop first elementS
        may_pass = false;
    }
       
  }

  /**
   * @advance
   */

  TIME advance() const noexcept { 
    TIME next_internal;
    
    if(may_pass && elements.size()>0){
      next_internal = TIME(0);
    }else{
      next_internal =  pdevs::atomic<TIME, MSG>::infinity; //passivate
    }

    return next_internal;
  }

  /**
   *@output
   */

  vector<MSG> out() const noexcept {    
    vector<MSG> out_put;
    MSG aux;

    if(elements.size()>0 && may_pass){
      aux.value = elements.front();
      aux.port = line_out;
      out_put.push_back(aux);
    }

    return out_put;
  }

  /**
   *@external
   */

  void external(const std::vector<MSG>& mb, const TIME& t) noexcept { 

      for(int i = 0; i<mb.size(); i++)
      {

        if( mb[i].port == new_person ) 
        {
          elements.push_back(mb[i].value);//Line is of infinite size
        }
        
        if (mb[i].port == ready_for_next) 
        {
          may_pass = true;//Line will output one person.
             
        }

      }
      
  }

  /**
   * @confluence 
  */

  virtual void confluence(const std::vector<MSG>& mb, const TIME& t) noexcept {
    internal();
    external(mb, TIME(0));

  }
};

#endif // BOOST_SIMULATION_PDEVS_LINE_HPP 
