#include <math.h>
#include <assert.h> 
#include <memory>
#include <iomanip>
#include <iostream>
#include <fstream>
#include <string>
#include <chrono>
#include <algorithm>
#include <limits>
#include <boost/simulation/pdevs/atomic.hpp>
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string.hpp>
#include <boost/simulation.hpp>

#include "../../vendor/britime.hpp"
#include "../../vendor/input_event_stream.hpp"
#include "../../data_structures/message.hpp"

//Include atomic models that make up the coupled model
#include "../../vendor/portConversor.hpp"
#include "../../vendor/filterPort.hpp"
#include "../../atomics/line.hpp"
#include "../../atomics/secondaryDecider.hpp"



using namespace std;
using namespace boost::simulation;
using namespace boost::simulation::pdevs;
using namespace boost::simulation::pdevs::basic_models;


using hclock = chrono::high_resolution_clock;
using Time =BRITime; 
using Message = Message_t; 


int main(int argc, char ** argv) {

  if (argc < 2) {
   cout << "you are using this program with wrong parameters. Te program should be invoked as follow:";
   cout << argv[0] << " path to the input file " << endl;
   return 1;  
  }
  
  string test_file = argv[1];
  ifstream file(test_file);
  string str;
  string file_contents;
  while (getline(file, str)){
    file_contents += str;
    file_contents.push_back('\n');
  }  
    
  string m_input;
  m_input = file_contents;

  cout << "model input:" << endl;
  cout << m_input << endl;

  shared_ptr<istringstream> piss1{ new istringstream{} };
  piss1->str(m_input);

  auto input_test_generator = make_atomic_ptr<input_event_stream<Time, Message, Time, Message>, shared_ptr<istringstream>, Time>(piss1, Time(0),
                [](const string& s, Time& t_next, Message& m_next)->void{ //parsing function
        
        string aux;
        m_next.clear();          
        istringstream ss;
                    
        ss.str(s);
        

        ss >> t_next;        
        ss >> m_next.port;
        ss >> m_next.value;
        
        
        string thrash;
        ss >> thrash;
        if ( 0 != thrash.size()) throw exception();         
  });
  
  
  // ATOMIC MODELS
  auto line3 = make_atomic_ptr<line<Time, Message>>();
  auto secondaryDecider1 = make_atomic_ptr<secondaryDecider<Time, Message>,double,double>(7.0,4.0);
  auto nextPerson_pc3 = make_atomic_ptr<portConversor<Time, Message>,string>(string("next_person"));
  auto readyForNext_pc3 = make_atomic_ptr<portConversor<Time, Message>,string>(string("ready_for_next"));
  auto isFree_f3 = make_atomic_ptr<filter<Time, Message>,string>(string("is_free"));
  auto ok_f5 = make_atomic_ptr<filter<Time, Message>,string>(string("ok")); 
  auto turnAway_f5 = make_atomic_ptr<filter<Time, Message>,string>(string("turn_away"));

  //COUPLED MODELS

  //COUPLED MODEL 1 = INTERVIEW
  shared_ptr<flattened_coupled<Time, Message>> interview(new flattened_coupled<Time, Message>(
  {line3, secondaryDecider1, nextPerson_pc3, readyForNext_pc3, isFree_f3, ok_f5, turnAway_f5}, //names of models in the coupled model
  {line3}, //EICs
  {{line3,nextPerson_pc3},{nextPerson_pc3,secondaryDecider1},{secondaryDecider1,isFree_f3},{isFree_f3,readyForNext_pc3},{readyForNext_pc3,line3},{secondaryDecider1,ok_f5},//ICs
  {secondaryDecider1,turnAway_f5}}, //ICS
  {ok_f5,turnAway_f5}//EOC
  ));  
  
  //COUPLED MODEL 2 = INTERVEIW_TEST
  shared_ptr<flattened_coupled<Time, Message>> INTERVEIW_TEST(new flattened_coupled<Time, Message>(
  {input_test_generator, interview}, //names of models in the coupled model
  {}, //EICs
  {{input_test_generator,interview}},//ICs
  {interview}//EOC
  ));  
  
 
    cout << "Preparing runner" << endl;
    Time initial_time = Time(0);
    ofstream out_data("interview_test_output.txt");  
    runner<Time, Message> r(INTERVEIW_TEST, initial_time, out_data, [](ostream& os, Message m){ os << m;});
    
    Time end_time = Time(1000000); //FINISHING TIME OF THE SIMULATION. 

    cout << "Starting simulation until time: " << end_time << "seconds" << endl;
    auto start = hclock::now();
    end_time = r.runUntil(end_time);
    auto elapsed = chrono::duration_cast<std::chrono::duration<double, std::ratio<1>>> (hclock::now() - start).count();     
    cout << "Finished simulation with time: " << end_time << "sec" << endl;
    cout << "Simulation took: " << elapsed << "sec" << endl;
    return 0;
}



    

   
