/**
* Ifeoluwa Oyelowo
* SYSC 5104 - Carleton University
* Nov 1, 2016
*
* secondaryDecider: 
  This model is a slight modification to the decider model.
  It accepts one person at a time from the line model.
  It decides after a time delay if a person should be turned away or is okay to cross the border.
  This model sends an is_free signal to the line model when it is ready to take the next person.
* atomic model secondaryDecider
*/

#ifndef BOOST_SIMULATION_PDEVS_SECONDARYDECIDER_HPP 
#define BOOST_SIMULATION_PDEVS_SECONDARYDECIDER_HPP 

#include <math.h> 
#include <assert.h>
#include <memory>
#include <iomanip>
#include <iostream>
#include <fstream>
#include <string>
#include <chrono>
#include <algorithm>
#include <limits>
#include <random>
#include <boost/simulation/pdevs/atomic.hpp>

#include <stdlib.h>

#include "../data_structures/message.hpp" 

using namespace boost::simulation::pdevs;
using namespace boost::simulation;
using namespace std;


/**
 * @class ATOMIC
*/


template<class TIME, class MSG>
class secondaryDecider : public pdevs::atomic<TIME, MSG>{ 
private:

  //PARAMETRES

  //Time distribution - normal
  double mean;
  double std_deviation;

  //input
  string next_person = string("next_person");

  //outputs
  string ok = string ("ok");
  string is_free = string("is_free");
  string turn_away = string("turn_away");
  
  
   

  
  //STATE VARIABLES
  int id;
  bool person_is_in; // The secondaryDecider has a person or does not have a person

public:

  /**
   * @constructor 
   */

  explicit secondaryDecider(double Mean, double stdDeviation) noexcept {   
    
    //INITIALIZE THE MODEL PARAMETERS AND VARIABLES.
    mean = Mean;
    std_deviation = stdDeviation;
    id = 1; 
    person_is_in = false;
    
  }

  /**
   * @Internal
   */

  void internal() noexcept {  
    //When the secondaryDecider has decided on the person, the secondaryDecider will wait for the next person in line.
    if(person_is_in){
        person_is_in = false;
    }
  } 

  /**
   * @advance
   */

  TIME advance() const noexcept { 

    unsigned seed = std::chrono::system_clock::now().time_since_epoch().count();// seed variable is used to ensure a different set of results for each simulation
    std::default_random_engine generator (seed);
    std::normal_distribution<double> dist(mean, std_deviation); // normal distribution where mean and std_deviation are input from the main.cpp
    TIME next_internal;

    if (person_is_in) {
      next_internal = TIME(fabs(static_cast < int > (round(dist(generator)))));//if secondaryDecider is deciding on a person, use normal distribution to generate a value for ta
    }else {
      next_internal = pdevs::atomic<TIME, MSG>::infinity;// if secondaryDecider is empty, ta = infinity 
    }    

    return next_internal;
  }

  /**
   *@output
   */

  vector<MSG> out() const noexcept {    
    vector<MSG> out_put;
    MSG tmp;

    // seed variable is used to ensure a different set of results for each simulation
    unsigned seed = std::chrono::system_clock::now().time_since_epoch().count();
    srand(seed);

    if (person_is_in) {

      if (((double)rand() / (double) RAND_MAX ) < 0.50) // 50% chance the person will be ok.
      {
        tmp.value = id;
        tmp.port = ok;
        out_put.push_back(tmp);
      }else{ //Otherwise, the person will be turned away
      
        tmp.value = id;
        tmp.port = turn_away;
        out_put.push_back(tmp);
      }

      //Whatever happens, the secondaryDecider will be marked as free for the line after a person leaves
      tmp.value = id;
      tmp.port = is_free;

      out_put.push_back(tmp);
    
    }
    //cout<<"here"<<endl;
    return out_put;
  }

  /**
   *@external
   */

  void external(const std::vector<MSG>& mb, const TIME& t) noexcept {     
assert(mb.size()==1&&"more than one message is arriving");// if more than one person is sent to the decider terminate simualation and output error
    
     if(mb[0].port == next_person) //New person is sent to this decider
     {
       id = mb[0].value;
       person_is_in = true;
     }
  }

  /**
   * @confluence 
  */

  virtual void confluence(const std::vector<MSG>& mb, const TIME& t) noexcept {
    internal();
    external(mb, TIME(0));
  }
};

#endif // BOOST_SIMULATION_PDEVS_SECONDARYDECIDER_HPP 
