 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Clearance
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __Trailer_truck_H
 #define __Trailer_truck_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class Trailer_truck : public Atomic
 {
   public:
	 	   Trailer_truck( const std::string &name = "Trailer_truck" );  //Default constructor
	       virtual std::string className() const {  return "Trailer_truck" ;}
	       ~Trailer_truck();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &trailerIn;
	        Port &trailerOut;
	        Time trailerTime;
	        int trailerState;
         	enum State{
			            trailerPassive,
			            trailerActive,
		              };
		    State state;
 };

#endif   //__Trailer_truck_H
