 /***********************************************
 *
 *  DESCRIPTION: Atomic Model State_check
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __State_check_H
 #define __State_check_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class State_check : public Atomic
 {
   public:
	 	   State_check( const std::string &name = "State_check" );  //Default constructor
	       virtual std::string className() const {  return "State_check" ;}
	       ~State_check();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &stateCIn;
	        Port &stateCOut,&stateFail;
	        Time procTime;
	        int interState;
         	enum State{
         		stateCPassive,
         		stateCActive,
		              };
		    State state;
 };

#endif   //__State_check_H
