 /***********************************************
 *
 *  DESCRIPTION: Atomic Model User Equipment (BS)
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 **********************************************/

 #include <modeladm.h>
 #include <mainsimu.h>

 #include "Buffer.h"
 #include "Proc.h"
 #include "Cabin_prepare.h"
 #include "Flight_plan.h"
 #include "Luggage.h"
 #include "State_check.h"
 #include "clearance.h"
 #include "Trailer_truck.h"
 #include "Sliding.h"

 void MainSimulator::registerNewAtomics()
 {
   SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Buffer>() , "Buffer" ) ;
   SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Proc>() , "Proc" ) ;
   SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Cabin_prepare>() , "Cabin_prepare" ) ;
   SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Flight_plan>() , "Flight_plan" ) ;
   SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Luggage>() , "Luggage" ) ;
   SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<State_check>() , "State_check" ) ;
   SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Clearance>() , "Clearance" ) ;
   SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Trailer_truck>() , "Trailer_truck" ) ;
   SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Sliding>() , "Sliding" ) ;
 }
