 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Proc
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __Proc_H
 #define __Proc_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class Proc : public Atomic
 {
   public:
	 	   Proc( const std::string &name = "Proc" );  //Default constructor
	       virtual std::string className() const {  return "Proc" ;}
	       ~Proc();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &procIn;
	        Port &procOut,&notificationOut;
	        Time procTime;
	        int procState;
         	enum State{
         		procPassive,
         		procActive,
		              };
		    State state;
 };

#endif   //__Proc_H
