 /***********************************************
 *
 *  DESCRIPTION: Atomic Model luggage
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __Luggage_H
 #define __Luggage_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class Luggage : public Atomic
 {
   public:
	 	   Luggage( const std::string &name = "Luggage" );  //Default constructor
	       virtual std::string className() const {  return "Luggage" ;}
	       ~Luggage();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &luggageIn;
	        Port &luggageOut;
	        Time luggageTime;
	        int luggageState;
         	enum State{
         		luggagePassive,
         		luggageActive,
		              };
		    State state;
 };

#endif   //__Luggage_H
