 /***********************************************
 *
 *  DESCRIPTION: Atomic Model luggage
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 *
 ***********************************************/

 #ifndef __Flight_plan_H
 #define __Flight_plan_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class Flight_plan : public Atomic
 {
   public:
	 	   Flight_plan( const std::string &name = "Flight_plan" );  //Default constructor
	       virtual std::string className() const {  return "Flight_plan" ;}
	       ~Flight_plan();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &pilotIn;
	        Port &planeReadyOut;
	        Time planTime;
	        int flightState;
         	enum State{
         		planPassive,
         		planActive,
		              };
		    State state;
 };

#endif   //__Flight_plan_H
