 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Flight_plan
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 *
 ***********************************************/

 #include "Flight_plan.h"
 #include "message.h"       // InternalMessage ....

 Flight_plan::Flight_plan( const std::string &name ) : Atomic( name )
 , pilotIn(addInputPort( "pilotIn" ))   		//clearance model only has one input
 , planeReadyOut(addOutputPort( "planeReadyOut" ))			//clearOut outputs
 , planTime (00,00,00,20)
 {
 }

 /*********************************************************/
 Model &Flight_plan::initFunction()
  {
	cout << "Flight_plan initFunction()" << endl;
    state = planPassive;
    passivate();
	return *this ;
  }

 /*********************************************************/
 Model &Flight_plan::externalFunction( const ExternalMessage &msg )
  {
	cout << "Flight_plan externalFunction() at " << msg.time() << endl;
	if (msg.port() == pilotIn ){ 	//from which port
		cout << "		I received state " << msg.value() << "   at " << msg.time() << endl;
		flightState = msg.value();
		//it should be this in the real world situation
		holdIn(Atomic::active, planTime);
		//passivate();
	}
	return *this;
  }

 /*********************************************************/
 Model &Flight_plan::internalFunction( const InternalMessage & )
 {
	cout << "Flight_plan internalFunction()" << endl;
	if (state == 0 ) cout << "		The input state is planPassive" << endl;
	if (state == 1 ) cout << "		The input state is planActive" << endl;

	switch (state){
				    case 0://clearPassive://state = 0
									passivate();
				    				//holdIn(Atomic::active, clearTime);
									break;
				    case 1://clearActive://state = 1;
									state = planPassive;
									break;
        		  }

	if (state == 0 ) cout << "		The input state is planPassive" << endl;
	if (state == 1 ) cout << "		The input state is planActive" << endl;
    return *this;
 }

 /*********************************************************/
 Model &Flight_plan::outputFunction( const InternalMessage &msg )
 {
	 cout << "Flight_plan outputFunction() at " << msg.time() << endl;
	 if (flightState == 1){   //output to clearOut port
		 sendOutput( msg.time(), planeReadyOut, flightState) ;//state = 1
		 cout << "		I sent planeReadyOut for flightState " << flightState << "   at " << msg.time() << endl;
	 }
	 if (flightState == 0){   //output to clearFail port
	 		 //sendOutput( msg.time(), clearOut, clearState) ;//state = 0
	 		//sendOutput( msg.time(), clearFail, clearState) ;//state = 0
	 		 cout << "		I sent planeReadyOut for flightState " << flightState << "   at " << msg.time() << endl;
	  }
	return *this ;
 }

 /*********************************************************/
 Flight_plan::~Flight_plan()
 {
 }

