 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Cabin_prepare
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __Cabin_prepare_H
 #define __Cabin_prepare_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class Cabin_prepare : public Atomic
 {
   public:
	 	   Cabin_prepare( const std::string &name = "Cabin_prepare" );  //Default constructor
	       virtual std::string className() const {  return "Cabin_prepare" ;}
	       ~Cabin_prepare();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &cabinCrewIn;
	        Port &cabinCheckedOut;
	        Time cabinTime;
	        int cabinState;
         	enum State{
         		cabinPassive,
         		cabinActive,
		              };
		    State state;
 };

#endif   //__Cabin_prepare_H
