 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Clearance
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 *
 ***********************************************/

 #include "Trailer_truck.h"
 #include "message.h"       // InternalMessage ....

 Trailer_truck::Trailer_truck( const std::string &name ) : Atomic( name )
 , trailerIn(addInputPort( "trailerIn" ))   		//clearance model only has one input
 , trailerOut(addOutputPort( "trailerOut" ))			//clearOut outputs
 , trailerTime (00,00,00,20)
 {
 }

 /*********************************************************/
 Model &Trailer_truck::initFunction()
  {
	cout << "Trailer_truck initFunction()" << endl;
    state = trailerPassive;
    passivate();
	return *this ;
  }

 /*********************************************************/
 Model &Trailer_truck::externalFunction( const ExternalMessage &msg )
  {
	cout << "Trailer_truck externalFunction() at " << msg.time() << endl;
	if (msg.port() == trailerIn ){ 	//from which port
		cout << "		I received state " << msg.value() << "   at " << msg.time() << endl;
		trailerState = msg.value();
		//it should be this in the real world situation
		holdIn(Atomic::active, trailerTime);
		//passivate();
	}
	return *this;
  }

 /*********************************************************/
 Model &Trailer_truck::internalFunction( const InternalMessage & )
 {
	cout << "Trailer_truck internalFunction()" << endl;
	if (state == 0 ) cout << "		The input state is trailerPassive" << endl;
	if (state == 1 ) cout << "		The input state is trailerActive" << endl;

	switch (state){
				    case 0://clearPassive://state = 0
									passivate();
				    				//holdIn(Atomic::active, clearTime);
									break;
				    case 1://clearActive://state = 1;
									state = trailerPassive;
									break;
        		  }

	if (state == 0 ) cout << "		The input state is trailerPassive" << endl;
	if (state == 1 ) cout << "		The input state is trailerActive" << endl;
    return *this;
 }

 /*********************************************************/
 Model &Trailer_truck::outputFunction( const InternalMessage &msg )
 {
	 cout << "Trailer_truck outputFunction() at " << msg.time() << endl;
	 if (trailerState == 1){   //output to clearOut port
		 sendOutput( msg.time(), trailerOut, trailerState) ;//state = 1
		 cout << "		I sent trailerOut for trailerState " << trailerState << "   at " << msg.time() << endl;
	 }
	 if (trailerState == 0){   //output to clearFail port
	 		 //sendOutput( msg.time(), clearOut, clearState) ;//state = 0
	 		//sendOutput( msg.time(), clearFail, clearState) ;//state = 0
	 		 cout << "		I sent trailerOut for trailerState " << trailerState << "   at " << msg.time() << endl;
	  }
	return *this ;
 }

 /*********************************************************/
 Trailer_truck::~Trailer_truck()
 {
 }

