 /***********************************************
 *
 *  DESCRIPTION: Atomic Model State_check
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 *
 ***********************************************/

 #include "State_check.h"
 #include "message.h"       // InternalMessage ....

 State_check::State_check( const std::string &name ) : Atomic( name )
 , stateCIn(addInputPort( "stateCIn" ))   		//clearance model only has one input
 , stateCOut(addOutputPort( "stateCOut" ))//two outputs
 , stateFail(addOutputPort( "stateFail" ))
 , procTime (00,00,00,20)
 {
 }

 /*********************************************************/
 Model &State_check::initFunction()
  {
	cout << "State_check initFunction()" << endl;
    state = stateCPassive;
    passivate();
	return *this ;
  }

 /*********************************************************/
 Model &State_check::externalFunction( const ExternalMessage &msg )
  {
	cout << "State_check externalFunction() at " << msg.time() << endl;
	if (msg.port() == stateCIn ){ 	//from which port
		cout << "		I received state " << msg.value() << "   at " << msg.time() << endl;
		interState = msg.value();
		//it should be this in the real world situation
		holdIn(Atomic::active, procTime);
		//passivate();
	}
	return *this;
  }

 /*********************************************************/
 Model &State_check::internalFunction( const InternalMessage & )
 {
	cout << "State_check internalFunction()" << endl;
	if (state == 0 ) cout << "		The input state is stateCPassive" << endl;
	if (state == 1 ) cout << "		The input state is stateCActive" << endl;

	switch (state){
				    case 0://stateCPassive://state = 0
									passivate();
				    				//holdIn(Atomic::active, procTime);
									break;
				    case 1://stateCActive://state = 1;
									state = stateCPassive;
									break;
        		  }

	if (state == 0 ) cout << "		The input state is stateCPassive" << endl;
	if (state == 1 ) cout << "		The input state is stateCActive" << endl;
    return *this;
 }

 /*********************************************************/
 Model &State_check::outputFunction( const InternalMessage &msg )
 {
	 cout << "State_check outputFunction() at " << msg.time() << endl;
	 if (interState == 1){   //output to stateCOut port
		 sendOutput( msg.time(), stateCOut, interState) ;//state = 1
		 cout << "		I sent stateCOut for interState " << interState << "   at " << msg.time() << endl;
	 }
	 if (interState == 0){   //output to stateFail port
	 		 //sendOutput( msg.time(), stateCOut, interState) ;//state = 0
	 		sendOutput( msg.time(), stateFail, interState) ;//state = 0
	 		 cout << "		I sent stateCOut for interState " << interState << "   at " << msg.time() << endl;
	  }
	return *this ;
 }

 /*********************************************************/
 State_check::~State_check()
 {
 }

