 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Sliding
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __Sliding_H
 #define __Sliding_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class Sliding : public Atomic
 {
   public:
	 	   Sliding( const std::string &name = "Sliding" );  //Default constructor
	       virtual std::string className() const {  return "Sliding" ;}
	       ~Sliding();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &slidingIn;
	        Port &slidingOut,&flowFail;
	        Time slidingTime;
	        int slidingState;
         	enum State{
         		slidingPassive,
         		slidingActive,
		              };
		    State state;
 };

#endif   //__Sliding_H
