 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Sliding
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 *
 ***********************************************/

 #include "Sliding.h"
 #include "message.h"       // InternalMessage ....

 Sliding::Sliding( const std::string &name ) : Atomic( name )
 , slidingIn(addInputPort( "slidingIn" ))   		//clearance model only has one input
 , slidingOut(addOutputPort( "slidingOut" ))//two outputs
 , flowFail(addOutputPort( "flowFail" ))
 , slidingTime (00,00,00,20)
 {
 }

 /*********************************************************/
 Model &Sliding::initFunction()
  {
	cout << "Sliding initFunction()" << endl;
    state = slidingPassive;
    passivate();
	return *this ;
  }

 /*********************************************************/
 Model &Sliding::externalFunction( const ExternalMessage &msg )
  {
	cout << "Sliding externalFunction() at " << msg.time() << endl;
	if (msg.port() == slidingIn ){ 	//from which port
		cout << "		I received state " << msg.value() << "   at " << msg.time() << endl;
		slidingState = msg.value();
		//it should be this in the real world situation
		holdIn(Atomic::active, slidingTime);
		//passivate();
	}
	return *this;
  }

 /*********************************************************/
 Model &Sliding::internalFunction( const InternalMessage & )
 {
	cout << "Sliding internalFunction()" << endl;
	if (state == 0 ) cout << "		The input state is slidingPassive" << endl;
	if (state == 1 ) cout << "		The input state is slidingActive" << endl;

	switch (state){
				    case 0://slidingPassive://state = 0
									passivate();
				    				//holdIn(Atomic::active, slidingTime);
									break;
				    case 1://slidingActive://state = 1;
									state = slidingPassive;
									break;
        		  }

	if (state == 0 ) cout << "		The input state is slidingPassive" << endl;
	if (state == 1 ) cout << "		The input state is slidingActive" << endl;
    return *this;
 }

 /*********************************************************/
 Model &Sliding::outputFunction( const InternalMessage &msg )
 {
	 cout << "Sliding outputFunction() at " << msg.time() << endl;
	 if (slidingState == 1){   //output to slidingOut port
		 sendOutput( msg.time(), slidingOut, slidingState) ;//state = 1
		 cout << "		I sent slidingOut for slidingState " << slidingState << "   at " << msg.time() << endl;
	 }
	 if (slidingState == 0){   //output to flowFail port
	 		 //sendOutput( msg.time(), slidingOut, slidingState) ;//state = 0
	 		sendOutput( msg.time(), flowFail, slidingState) ;//state = 0
	 		 cout << "		I sent slidingOut for slidingState " << slidingState << "   at " << msg.time() << endl;
	  }
	return *this ;
 }

 /*********************************************************/
 Sliding::~Sliding()
 {
 }

