 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Proc
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 *
 ***********************************************/

 #include "Proc.h"
 #include "message.h"       // InternalMessage ....

 Proc::Proc( const std::string &name ) : Atomic( name )
 , procIn(addInputPort( "procIn" ))   		//clearance model only has one input
 , procOut(addOutputPort( "procOut" ))//two outputs
 , notificationOut(addOutputPort( "notificationOut" ))
 , procTime (00,00,00,20)
 {
 }

 /*********************************************************/
 Model &Proc::initFunction()
  {
	cout << "Proc initFunction()" << endl;
    state = procPassive;
    passivate();
	return *this ;
  }

 /*********************************************************/
 Model &Proc::externalFunction( const ExternalMessage &msg )
  {
	cout << "Proc externalFunction() at " << msg.time() << endl;
	if (msg.port() == procIn ){ 	//from which port
		cout << "		I received state " << msg.value() << "   at " << msg.time() << endl;
		procState = msg.value();
		//it should be this in the real world situation
		holdIn(Atomic::active, procTime);
		//passivate();
	}
	return *this;
  }

 /*********************************************************/
 Model &Proc::internalFunction( const InternalMessage & )
 {
	cout << "Proc internalFunction()" << endl;
	if (state == 0 ) cout << "		The input state is procPassive" << endl;
	if (state == 1 ) cout << "		The input state is procActive" << endl;

	switch (state){
				    case 0://procPassive://state = 0
									passivate();
				    				//holdIn(Atomic::active, procTime);
									break;
				    case 1://procActive://state = 1;
									state = procPassive;
									break;
        		  }

	if (state == 0 ) cout << "		The input state is procPassive" << endl;
	if (state == 1 ) cout << "		The input state is procActive" << endl;
    return *this;
 }

 /*********************************************************/
 Model &Proc::outputFunction( const InternalMessage &msg )
 {
	 cout << "Proc outputFunction() at " << msg.time() << endl;
	 if (procState == 1){   //output to procOut port
		 sendOutput( msg.time(), procOut, procState) ;//state = 1
		 cout << "		I sent procOut for procState " << procState << "   at " << msg.time() << endl;
	 }
	 if (procState == 0){   //output to notificationOut port
	 		 //sendOutput( msg.time(), procOut, procState) ;//state = 0
	 		sendOutput( msg.time(), notificationOut, procState) ;//state = 0
	 		 cout << "		I sent procOut for procState " << procState << "   at " << msg.time() << endl;
	  }
	return *this ;
 }

 /*********************************************************/
 Proc::~Proc()
 {
 }

