 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Luggage
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 *
 ***********************************************/

 #include "Luggage.h"
 #include "message.h"       // InternalMessage ....

 Luggage::Luggage( const std::string &name ) : Atomic( name )
 , luggageIn(addInputPort( "luggageIn" ))   		//clearance model only has one input
 , luggageOut(addOutputPort( "luggageOut" ))			//clearOut outputs
 , luggageTime (00,00,00,20)
 {
 }

 /*********************************************************/
 Model &Luggage::initFunction()
  {
	cout << "Luggage initFunction()" << endl;
    state = luggagePassive;
    passivate();
	return *this ;
  }

 /*********************************************************/
 Model &Luggage::externalFunction( const ExternalMessage &msg )
  {
	cout << "Luggage externalFunction() at " << msg.time() << endl;
	if (msg.port() == luggageIn ){ 	//from which port
		cout << "		I received state " << msg.value() << "   at " << msg.time() << endl;
		luggageState = msg.value();
		//it should be this in the real world situation
		holdIn(Atomic::active, luggageTime);
		//passivate();
	}
	return *this;
  }

 /*********************************************************/
 Model &Luggage::internalFunction( const InternalMessage & )
 {
	cout << "Luggage internalFunction()" << endl;
	if (state == 0 ) cout << "		The input state is luggagePassive" << endl;
	if (state == 1 ) cout << "		The input state is luggageActive" << endl;

	switch (state){
				    case 0://clearPassive://state = 0
									passivate();
				    				//holdIn(Atomic::active, clearTime);
									break;
				    case 1://clearActive://state = 1;
									state = luggagePassive;
									break;
        		  }

	if (state == 0 ) cout << "		The input state is luggagePassive" << endl;
	if (state == 1 ) cout << "		The input state is luggageActive" << endl;
    return *this;
 }

 /*********************************************************/
 Model &Luggage::outputFunction( const InternalMessage &msg )
 {
	 cout << "Luggage outputFunction() at " << msg.time() << endl;
	 if (luggageState == 1){   //output to clearOut port
		 sendOutput( msg.time(), luggageOut, luggageState) ;//state = 1
		 cout << "		I sent luggageOut for luggageState " << luggageState << "   at " << msg.time() << endl;
	 }
	 if (luggageState == 0){   //output to clearFail port
	 		 //sendOutput( msg.time(), clearOut, clearState) ;//state = 0
	 		//sendOutput( msg.time(), clearFail, clearState) ;//state = 0
	 		 cout << "		I sent luggageOut for luggageState " << luggageState << "   at " << msg.time() << endl;
	  }
	return *this ;
 }

 /*********************************************************/
 Luggage::~Luggage()
 {
 }

