 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Clearance
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __Clearance_H
 #define __Clearance_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class Clearance : public Atomic
 {
   public:
	       Clearance( const std::string &name = "Clearance" );  //Default constructor
	       virtual std::string className() const {  return "Clearance" ;}
	       ~Clearance();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &clearIn;
	        Port &clearOut,&clearFail;
	        Time clearTime;
	        int clearState;
         	enum State{
			            clearPassive,
			            clearActive,
		              };
		    State state;
 };

#endif   //__Clearance_H
