 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Clearance
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 *
 ***********************************************/

 #include "Clearance.h"
 #include "message.h"       // InternalMessage ....

 Clearance::Clearance( const std::string &name ) : Atomic( name )
 , clearIn(addInputPort( "clearIn" ))   		//clearance model only has one input
 , clearOut(addOutputPort( "clearOut" ))//two outputs
 , clearFail(addOutputPort( "clearFail" ))
 , clearTime (00,00,00,20)
 {
 }

 /*********************************************************/
 Model &Clearance::initFunction()
  {
	cout << "Clearance initFunction()" << endl;
    state = clearPassive;
    passivate();
	return *this ;
  }

 /*********************************************************/
 Model &Clearance::externalFunction( const ExternalMessage &msg )
  {
	cout << "Clearance externalFunction() at " << msg.time() << endl;
	if (msg.port() == clearIn ){ 	//from which port
		cout << "		I received state " << msg.value() << "   at " << msg.time() << endl;
		clearState = msg.value();
		//it should be this in the real world situation
		holdIn(Atomic::active, clearTime);
		//passivate();
	}
	return *this;
  }

 /*********************************************************/
 Model &Clearance::internalFunction( const InternalMessage & )
 {
	cout << "Clearance internalFunction()" << endl;
	if (state == 0 ) cout << "		The input state is clearPassive" << endl;
	if (state == 1 ) cout << "		The input state is clearActive" << endl;

	switch (state){
				    case 0://clearPassive://state = 0
									passivate();
				    				//holdIn(Atomic::active, clearTime);
									break;
				    case 1://clearActive://state = 1;
									state = clearPassive;
									break;
        		  }

	if (state == 0 ) cout << "		The input state is clearPassive" << endl;
	if (state == 1 ) cout << "		The input state is clearActive" << endl;
    return *this;
 }

 /*********************************************************/
 Model &Clearance::outputFunction( const InternalMessage &msg )
 {
	 cout << "Clearance outputFunction() at " << msg.time() << endl;
	 if (clearState == 1){   //output to clearOut port
		 sendOutput( msg.time(), clearOut, clearState) ;//state = 1
		 cout << "		I sent clearOut for clearState " << clearState << "   at " << msg.time() << endl;
	 }
	 if (clearState == 0){   //output to clearFail port
	 		 //sendOutput( msg.time(), clearOut, clearState) ;//state = 0
	 		sendOutput( msg.time(), clearFail, clearState) ;//state = 0
	 		 cout << "		I sent clearOut for clearState " << clearState << "   at " << msg.time() << endl;
	  }
	return *this ;
 }

 /*********************************************************/
 Clearance::~Clearance()
 {
 }

