 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Cabin_prepare
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 *
 ***********************************************/

 #include "Cabin_prepare.h"
 #include "message.h"       // InternalMessage ....

 Cabin_prepare::Cabin_prepare( const std::string &name ) : Atomic( name )
 , cabinCrewIn(addInputPort( "cabinCrewIn" ))   		//clearance model only has one input
 , cabinCheckedOut(addOutputPort( "cabinCheckedOut" ))			//clearOut outputs
 , cabinTime (00,00,00,20)
 {
 }

 /*********************************************************/
 Model &Cabin_prepare::initFunction()
  {
	cout << "Cabin_prepare initFunction()" << endl;
    state = cabinPassive;
    passivate();
	return *this ;
  }

 /*********************************************************/
 Model &Cabin_prepare::externalFunction( const ExternalMessage &msg )
  {
	cout << "Cabin_prepare externalFunction() at " << msg.time() << endl;
	if (msg.port() == cabinCrewIn ){ 	//from which port
		cout << "		I received state " << msg.value() << "   at " << msg.time() << endl;
		cabinState = msg.value();
		//it should be this in the real world situation
		holdIn(Atomic::active, cabinTime);
		//passivate();
	}
	return *this;
  }

 /*********************************************************/
 Model &Cabin_prepare::internalFunction( const InternalMessage & )
 {
	cout << "Cabin_prepare internalFunction()" << endl;
	if (state == 0 ) cout << "		The input state is cabinPassive" << endl;
	if (state == 1 ) cout << "		The input state is cabinActive" << endl;

	switch (state){
				    case 0://clearPassive://state = 0
									passivate();
				    				//holdIn(Atomic::active, clearTime);
									break;
				    case 1://clearActive://state = 1;
									state = cabinPassive;
									break;
        		  }

	if (state == 0 ) cout << "		The input state is cabinPassive" << endl;
	if (state == 1 ) cout << "		The input state is cabinActive" << endl;
    return *this;
 }

 /*********************************************************/
 Model &Cabin_prepare::outputFunction( const InternalMessage &msg )
 {
	 cout << "Cabin_prepare outputFunction() at " << msg.time() << endl;
	 if (cabinState == 1){   //output to clearOut port
		 sendOutput( msg.time(), cabinCheckedOut, cabinState) ;//state = 1
		 cout << "		I sent cabinCheckedOut for cabinState " << cabinState << "   at " << msg.time() << endl;
	 }
	 if (cabinState == 0){   //output to clearFail port
	 		 //sendOutput( msg.time(), clearOut, clearState) ;//state = 0
	 		//sendOutput( msg.time(), clearFail, clearState) ;//state = 0
	 		 cout << "		I sent cabinCheckedOut for cabinState " << cabinState << "   at " << msg.time() << endl;
	  }
	return *this ;
 }

 /*********************************************************/
 Cabin_prepare::~Cabin_prepare()
 {
 }

