 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Buffer
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __Buffer_H
 #define __Buffer_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class Buffer : public Atomic
 {
   public:
	 	   Buffer( const std::string &name = "Buffer" );  //Default constructor
	       virtual std::string className() const {  return "Buffer" ;}
	       ~Buffer();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &bufferIn;
	        Port &bufferOut;
	        Time bufferTime;
	        int bufferState;
         	enum State{
         		OutPassive,
         		OutActive,
		              };
		    State state;
 };

#endif   //__Buffer_H
