 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Buffer
 *
 *  AUTHOR: Zheng Xia
 *
 *  DATE: 21/10/2014
 *
 ***********************************************/

 #include "Buffer.h"
 #include "message.h"       // InternalMessage ....

 Buffer::Buffer( const std::string &name ) : Atomic( name )
 , bufferIn(addInputPort( "bufferIn" ))   		//clearance model only has one input
 , bufferOut(addOutputPort( "bufferOut" ))			//clearOut outputs
 , bufferTime (00,00,00,20)
 {
 }

 /*********************************************************/
 Model &Buffer::initFunction()
  {
	cout << "Buffer initFunction()" << endl;
    state = OutPassive;
    passivate();
	return *this ;
  }

 /*********************************************************/
 Model &Buffer::externalFunction( const ExternalMessage &msg )
  {
	cout << "Buffer externalFunction() at " << msg.time() << endl;
	if (msg.port() == bufferIn ){ 	//from which port
		cout << "		I received state " << msg.value() << "   at " << msg.time() << endl;
		bufferState = msg.value();
		//it should be this in the real world situation
		holdIn(Atomic::active, bufferTime);
		//passivate();
	}
	return *this;
  }

 /*********************************************************/
 Model &Buffer::internalFunction( const InternalMessage & )
 {
	cout << "Buffer internalFunction()" << endl;
	if (state == 0 ) cout << "		The input state is OutPassive" << endl;
	if (state == 1 ) cout << "		The input state is OutActive" << endl;

	switch (state){
				    case 0://clearPassive://state = 0
									passivate();
				    				//holdIn(Atomic::active, clearTime);
									break;
				    case 1://clearActive://state = 1;
									state = OutPassive;
									break;
        		  }

	if (state == 0 ) cout << "		The input state is OutPassive" << endl;
	if (state == 1 ) cout << "		The input state is OutActive" << endl;
    return *this;
 }

 /*********************************************************/
 Model &Buffer::outputFunction( const InternalMessage &msg )
 {
	 cout << "Buffer outputFunction() at " << msg.time() << endl;
	 if (bufferState == 1){   //output to clearOut port
		 sendOutput( msg.time(), bufferOut, bufferState) ;//state = 1
		 cout << "		I sent bufferOut for bufferState " << bufferState << "   at " << msg.time() << endl;
	 }
	 if (bufferState == 0){   //output to clearFail port
	 		 //sendOutput( msg.time(), clearOut, clearState) ;//state = 0
	 		//sendOutput( msg.time(), clearFail, clearState) ;//state = 0
	 		 cout << "		I sent bufferOut for bufferState " << bufferState << "   at " << msg.time() << endl;
	  }
	return *this ;
 }

 /*********************************************************/
 Buffer::~Buffer()
 {
 }

