[top]
components : TruckMovement

[TruckMovement]
type : cell
width : 30
height : 30
delay : transport
defaultDelayTime : 400
border : wrapped
neighbors : 						 TruckMovement(2,-1) TruckMovement(2,0) TruckMovement(2,1)
neighbors : 						 TruckMovement(1,-1) TruckMovement(1,0) TruckMovement(1,1)
neighbors : TruckMovement(0,-2) TruckMovement(0,-1) TruckMovement(0,0) TruckMovement(0,1) TruckMovement(0,2)
neighbors : 						 TruckMovement(-1,-1) TruckMovement(-1,0) TruckMovement(-1,1)
neighbors : 						 TruckMovement(-2,-1) TruckMovement(-2,0) TruckMovement(-2,1)
%%%% state values %%%%
% 0 - cell unoccupied
% 1 - cell occupied with an upward moving truck
% 2 - cell occupied with a downward moving truck
% 3 - cell occupied with other static vehicle
initialvalue : 0
initialrowvalue :  0     000000000000000000000020000000
initialrowvalue :  1     000003000000001000000000000100
initialrowvalue :  2     000001000000000000003330000000
initialrowvalue :  3     020000000030000002000000000000
initialrowvalue :  4     000000000330000000000100000200
initialrowvalue :  5     000000000300000000000000000300
initialrowvalue :  6     000200000020000300000000030000
initialrowvalue :  7     000000000000000200031000000000
initialrowvalue :  8     003000000000000000000000000000
initialrowvalue :  9     000000020000030000000000000000
initialrowvalue :  10    000000010000330000000000000300
initialrowvalue :  11    000000030000020000000000000000
initialrowvalue :  12    000030000000000000000000100000
initialrowvalue :  13    001000000200000010000000000002
initialrowvalue :  14    000000000003000000003000000001
initialrowvalue :  15    000000000000000100000000002000
initialrowvalue :  16    330000003000000200000000300000
initialrowvalue :  17    000000000010000003000000000033
initialrowvalue :  18    000000000000000000000000000000
initialrowvalue :  19    000200000000000000000001000000
initialrowvalue :  20    000330001000000030000020000000
initialrowvalue :  21    000300000000000000000000000000
initialrowvalue :  22    000000000000002000000000000000
initialrowvalue :  23    000000300000000000000003000001
initialrowvalue :  24    000002000000000000000033000000
initialrowvalue :  25    000000000000003000300000000000
initialrowvalue :  26    000003000000003000002000003000
initialrowvalue :  27    000001000000003000000010000000
initialrowvalue :  28    000000000000000000100000000000
initialrowvalue :  29    000000000000000000000000100000

localtransition : TruckDirection

[TruckDirection]
%%%% Rule 1 %%%%
% Move forward - upward trucks
rule : 0 100 {(0,0)=1 and (-1,0)=0 and (-2,0)!=2}	 %the cell ahead is available and
rule : 1 100 {(0,0)=0 and (-1,0)!=2 and (1,0)=1}	 %the next cell is not a downward truck
% Move forward - downward trucks
rule : 0 100 {(0,0)=2 and (1,0)=0 and (2,0)!=1}
rule : 2 100 {(0,0)=0 and (1,0)!=1 and (-1,0)=2}
				
%%%% Rule 2 %%%%
% There is a truck/other static vehicle ahead, move to right lane if another truck isn`t going to go there
% upward truck
rule : 0 100 {(0,0)=1 and (-1,0)!=0		% truck or other static vehicle is next cell ahead
				and (0,1)=0				% and the right lane is available
				and (-1,1)!=2			% ensure downward truck is not going for that cell
				and (1,1)!=1}			% ensure upward truck is not going for that cell
rule : 1 100 {(0,0)=0 and (0,-1)=1		% move the upward truck to the right lane
				and (-1,-1)!=0			% there is a static vehicle or truck in cell (-1,-1)
				and (-1,0)!=2			% ensure downward truck is not going for that cell
				and (1,0)!=1}			% ensure upward truck is not going for that cell
% downward truck
rule : 0 100 {(0,0)=2 and (1,0)!=0		% truck or other vehicle is next cell ahead
				and (0,-1)=0			% and the right lane is available
				and (1,-1)!=1			% ensure upward truck is not going for that cell
				and (-1,-1)!=2}			% ensure downward truck is not going for that cell
				
rule : 2 100 {(0,0)=0 and (0,1)=2		% move the downward truck to the right
				and (1,1)!=0			% there is a vehicle or truck in cell (1,1)
				and (1,0)!=1			% ensure upward truck is not going for that cell
				and (-1,0)!=2}			% ensure downward truck is not going for your cell
%%%% Rule 3 %%%%
% truck/vehicle ahead and to the right, move to the left if another truck isn`t going to move there
% upward truck
rule : 0 100 {(0,0)=1 and (-1,0)!=0		% truck or vehicle is next cell ahead
				and (0,1)!=0			% truck or vehicle is also to the right
				and (0,-1)=0			% the left lane is available
				and (-1,-1)!=2			% ensure downward truck is not going for left cell
				and (1,-1)!=1}			% ensure upward truck is not going for left cell
rule : 1 100 {(0,0)=0 and (0,1)=1		% move the upward truck to the left
				and (-1,1)!=0			% there is a vehicle or truck in cell (-1,1)
				and (0,2)!=0			% there is an vehicle or truck in cell (0,2) also
				and (-1,0)!=2			% ensure downward truck is not going for that cell
				and (1,0)!=1}			% ensure upward truck is not going for that cell
% downward truck
rule : 0 100 {(0,0)=2 and (1,0)!=0		% truck or vehicle is next cell ahead
				and (0,-1)!=0			% and the right lane is an vehicle or truck
				and (0,1)=0				% the left lane is available
				and (1,1)!=1			% ensure upward truck is not going for left cell
				and (-1,1)!=2}			% ensure downward truck is not going for left cell
				
rule : 2 100 {(0,0)=0 and (0,-1)=2		% move the downward truck to the right lane
				and (1,-1)!=0			% there is a vehicle or truck in cell (1,-1)
				and (0,-2)!=0			% there is a vehicle or truck in cell (0,-2) also
				and (1,0)!=1			% ensure upward truck is not going for that cell
				and (-1,0)!=2}			% ensure downward truck is not going for that cell
%%%% Rule 4 %%%%
% to avoid collision, move right lane if an upward and downward trucks are going for the same cell and it's possible to move
% upward truck
rule : 0 100 {(0,0)=1 and (1,0)=0 		% cell ahead is empty
				and (-2,0)=2 			% 2 cells ahead is downward truck
				and (0,1)=0				% right cell is available
				and (-1,1)!=2			% ensure downward truck is not going for right cell
				and (1,1)!=1}			% ensure upward truck is not going for right cell
rule : 1 100 {(0,0)=0 and (0,-1)=1
				and (-2,-1)=2			% cell (-2,-1) is a downward truck
				and (-1,-1)=0			% cell (-1,-1) is empty
				and (-1,0)!=2			% ensure downward truck is not going for right cell
				and (1,0)!=1}			% ensure upward truck is not going for right cell
% downward truck
rule : 0 100 {(0,0)=2 and (1,0)=0		% cell ahead is empty
				and (2,0)=1				% 2 cells ahead is upward truck
				and (0,-1)=0			% right cell is available
				and (1,-1)!=1			% ensure upward truck is not going for right cell
				and (-1,-1)!=2}			% ensure downward truck is not going for right cell
rule : 2 100 {(0,0)=0 and (0,1)=2
				and (2,1)=1				% cell (2,1) is an upward truck
				and (1,1)=0				% cell (1,1) is empty
				and (1,0)!=1			% ensure upward truck is not going for right cell
				and (-1,0)!=2}			% ensure downward truck is not going for right cell

%%%% Rule 5 %%%%
% Default - truck doesnt move, stays in the current position
rule : {(0,0)} 100 {t}