/*
 * Decompiled with CFR 0.152.
 */
package parsers.lopez;

import components.FilesMap;
import components.Helper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import models.simulation.IEmitter;
import models.simulation.MessageCA;
import models.simulation.Model;
import models.simulation.Port;
import models.simulation.Structure;
import models.simulation.StructureInfo;
import parsers.ILogParser;
import parsers.shared.Ma;

public class CellDevs
implements ILogParser {
    private static final String TEMPLATE = "{\"value\":${0}}";

    @Override
    public Structure Parse(FilesMap files) throws IOException {
        Ma maParser = new Ma();
        Structure structure = maParser.ParseCA(files.FindStream(".ma"), TEMPLATE);
        structure.setInfo(new StructureInfo(files.FindName(".ma"), "Lopez", "Cell-DEVS"));
        CellDevs.FixStructure(structure);
        CellDevs.ParseLog(structure, files.FindStream(".log"));
        return structure;
    }

    private static void FixStructure(Structure structure) {
        structure.getPorts().forEach(p -> p.setName("out_" + p.getName()));
        structure.getNodes().forEach(m -> structure.CreatePort((Model)m, "out", Port.Type.OUTPUT, TEMPLATE));
    }

    private static void ParseLog(Structure structure, InputStream log) throws IOException {
        ArrayList messages = new ArrayList();
        Helper.ReadFile(log, l -> {
            if (!l.startsWith("0 / L / Y")) {
                return;
            }
            String[] split = (String[])Arrays.stream(l.split("/")).map(s -> s.trim()).toArray(String[]::new);
            String[] tmp1 = split[4].split("\\(");
            String[] tmp2 = tmp1[1].substring(0, tmp1[1].length() - 1).split(",");
            String t = split[3].trim();
            String m = tmp1[0];
            String p = split[5];
            String v = split[6];
            int[] c = new int[]{Integer.parseInt(tmp2[0]), Integer.parseInt(tmp2[1]), tmp2.length == 2 ? 0 : Integer.parseInt(tmp2[2])};
            BigDecimal number = new BigDecimal(v);
            v = number.stripTrailingZeros().toPlainString();
            if (!structure.getTimesteps().contains(t)) {
                structure.getTimesteps().add(t);
            }
            Port port = structure.FindPort(m, p);
            messages.add(new MessageCA(structure.getTimesteps().size() - 1, (IEmitter)port, c, v));
        });
        structure.setMessages(messages);
    }

    @Override
    public Boolean Validate(FilesMap files) throws IOException {
        String ma = files.FindKey(".ma");
        InputStream log = (InputStream)files.get(files.FindKey(".log"));
        if (ma == null || log == null) {
            return false;
        }
        List<String> lines = Helper.ReadNLines(log, 1);
        log.reset();
        return lines.get(0).contains("0 / L / ");
    }
}

