/*
 * Decompiled with CFR 0.152.
 */
package parsers.cdpp;

import components.FilesMap;
import components.Helper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import models.simulation.IEmitter;
import models.simulation.Message;
import models.simulation.Model;
import models.simulation.Port;
import models.simulation.Structure;
import models.simulation.StructureInfo;
import parsers.ILogParser;
import parsers.shared.Ma;

public class Devs
implements ILogParser {
    private static final String TEMPLATE = "{\"value\":${0}}";

    @Override
    public Structure Parse(FilesMap files) throws IOException {
        Ma maParser = new Ma();
        Structure structure = maParser.Parse(files.FindStream(".ma"), TEMPLATE);
        structure.setInfo(new StructureInfo(files.FindName(".ma"), "CDpp", "DEVS"));
        Devs.ParseLog(structure, files.FindStream("log"));
        return structure;
    }

    private static void ParseLog(Structure structure, InputStream log) throws IOException {
        ArrayList messages = new ArrayList();
        Helper.ReadFile(log, l -> {
            if (!l.startsWith("Mensaje Y")) {
                return;
            }
            String[] split = (String[])Arrays.stream(l.split("/")).map(s -> s.trim()).toArray(String[]::new);
            String[] tmp1 = split[2].split("\\(");
            String[] tmp2 = split[4].trim().split(" ");
            String m = tmp1[0];
            if (structure.FindNode(m).getType() == Model.Type.COUPLED) {
                return;
            }
            String t = split[1];
            String p = split[3];
            String v = tmp2[0];
            BigDecimal number = new BigDecimal(v);
            v = number.stripTrailingZeros().toPlainString();
            if (!structure.getTimesteps().contains(t)) {
                structure.getTimesteps().add(t);
            }
            Port port = structure.FindPort(m, p);
            messages.add(new Message(structure.getTimesteps().size() - 1, (IEmitter)port, v));
        });
        structure.setMessages(messages);
    }

    @Override
    public Boolean Validate(FilesMap files) throws IOException {
        InputStream ma = (InputStream)files.get(files.FindKey(".ma"));
        InputStream log = (InputStream)files.get(files.FindKey(".log"));
        if (ma == null || log == null) {
            return false;
        }
        List<String> lines = Helper.ReadNLines(ma, 10);
        ma.reset();
        long count = lines.stream().filter(l -> l.contains("type") && l.contains("cell")).count();
        return count == 0L;
    }
}

