/*
 * Decompiled with CFR 0.152.
 */
package parsers.cadmium;

import com.fasterxml.jackson.databind.ObjectMapper;
import components.FilesMap;
import components.Helper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import models.simulation.IEmitter;
import models.simulation.Link;
import models.simulation.Message;
import models.simulation.Model;
import models.simulation.Port;
import models.simulation.Structure;
import models.simulation.StructureInfo;
import parsers.ILogParser;
import parsers.cadmium.config.devs.Model;

public class Devs
implements ILogParser {
    private static final String TEMPLATE = "{\"value\":${0}}";

    @Override
    public Structure Parse(FilesMap files) throws IOException {
        Structure structure = this.ParseStructure(files.FindStream(".json"));
        structure.setInfo(new StructureInfo(files.FindName("message"), "Cadmium", "DEVS"));
        this.ParseLog(structure, files.FindStream("message"));
        return structure;
    }

    public Structure ParseStructure(InputStream json) throws IOException {
        Structure s = new Structure();
        ObjectMapper mapper = new ObjectMapper();
        Model jModel = mapper.readValue(json, Model.class);
        jModel.Traverse(m -> {
            Model.Type mType = m.getSubmodels().size() > 0 ? Model.Type.COUPLED : Model.Type.ATOMIC;
            models.simulation.Model sModel = s.CreateModel(m.getName(), mType, TEMPLATE);
            m.getPorts().forEach(p -> {
                Port.Type pType = p.getType() == "output" ? Port.Type.OUTPUT : Port.Type.INPUT;
                s.CreatePort(sModel, p.getName(), pType, TEMPLATE);
            });
        });
        jModel.Traverse(m -> m.getCouplings().forEach(c -> {
            c.setModel(m.getName());
            Port start = s.FindPort(c.getModelA(), c.getPortA());
            Port end = s.FindPort(c.getModelB(), c.getPortB());
            s.getLinks().add(new Link(start, end));
        }));
        return s;
    }

    private void ParseLog(Structure structure, InputStream log) throws IOException {
        ArrayList messages = new ArrayList();
        Helper.ReadFile(log, l -> {
            if (l.startsWith("[")) {
                int i = l.indexOf(93) + 1;
                String left = l.substring(0, i);
                String right = l.substring(i);
                String m = right.trim().split(" ")[3];
                String clean = left.substring(1, left.length() - 1).replace(" ", "").replace("::", ":");
                Arrays.stream(clean.split("\\}")).forEach(s -> {
                    String[] e = s.split(":");
                    String v = e[e.length - 1].replaceAll("\\{|\\}|<|>|\\s", "");
                    if (v.length() == 0) {
                        return;
                    }
                    String p = e[e.length - 2];
                    Port port = structure.FindPort(m, p);
                    messages.add(new Message(structure.getTimesteps().size() - 2, (IEmitter)port, v.split(",")));
                });
            } else {
                structure.getTimesteps().add(l);
            }
        });
        structure.getTimesteps().remove(0);
        structure.setMessages(messages);
    }

    @Override
    public Boolean Validate(FilesMap files) throws IOException {
        BufferedInputStream messages = files.FindStream("message");
        if (messages == null) {
            return false;
        }
        List<String> lines = Helper.ReadNLines(messages, 3);
        ((InputStream)messages).reset();
        long n1 = lines.get(2).chars().filter(c -> c == 40).count();
        long n2 = lines.get(2).chars().filter(c -> c == 41).count();
        return n1 == 0L && n2 == 0L;
    }
}

