/*
 * Decompiled with CFR 0.152.
 */
package parsers.auto;

import components.FilesMap;
import java.io.IOException;
import models.simulation.Structure;
import parsers.ILogParser;
import parsers.IParser;
import parsers.cdpp.CellDevs;
import parsers.cdpp.Devs;

public class Auto
implements IParser {
    @Override
    public Structure Parse(FilesMap files) throws IOException {
        ILogParser parser = this.DetectParser(files);
        if (parser == null) {
            throw new RuntimeException("Unable to automatically detect parser from files.");
        }
        Structure result = parser.Parse(files);
        return result;
    }

    private ILogParser DetectParser(FilesMap files) throws IOException {
        ILogParser parser = this.TryParser(new parsers.lopez.CellDevs(), files);
        if (parser == null) {
            parser = this.TryParser(new CellDevs(), files);
        }
        if (parser == null) {
            parser = this.TryParser(new Devs(), files);
        }
        if (parser == null) {
            parser = this.TryParser(new parsers.cadmium.CellDevs(), files);
        }
        if (parser == null) {
            parser = this.TryParser(new parsers.cadmium.Devs(), files);
        }
        return parser;
    }

    private ILogParser TryParser(ILogParser parser, FilesMap files) throws IOException {
        Boolean valid = parser.Validate(files);
        return valid != false ? parser : null;
    }
}

