/*
 * Decompiled with CFR 0.152.
 */
package models.simulation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import models.simulation.IEmitter;
import models.simulation.Model;

@JsonPropertyOrder(value={"model", "name", "type"})
public class Port
implements Serializable,
IEmitter {
    private static final long serialVersionUID = 4L;
    @JsonIgnore
    private Model node;
    @JsonIgnore
    private int index;
    @JsonIgnore
    private Type type;
    @JsonIgnore
    private String template;
    @JsonProperty(value="name")
    private String name;

    @JsonProperty(value="model")
    public String getNodeIndex() {
        return this.node.getName();
    }

    @JsonProperty(value="type")
    public String getTypeString() {
        return this.getType().toString().toLowerCase();
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int value) {
        this.index = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    public Model getNode() {
        return this.node;
    }

    public Port(Model node, String name, Type type, String template) {
        this.node = node;
        this.name = name;
        this.type = type;
        this.template = template;
    }

    public static enum Type {
        INPUT,
        OUTPUT;

    }
}

